(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('tslib'), require('apollo-link')) :
  typeof define === 'function' && define.amd ? define(['exports', 'tslib', 'apollo-link'], factory) :
  (global = global || self, factory((global.apolloLink = global.apolloLink || {}, global.apolloLink.context = {}), global.tslib, global.apolloLink.core));
}(this, (function (exports, tslib_1, apolloLink) { 'use strict';

  function setContext(setter) {
      return new apolloLink.ApolloLink(function (operation, forward) {
          var request = tslib_1.__rest(operation, []);
          return new apolloLink.Observable(function (observer) {
              var handle;
              Promise.resolve(request)
                  .then(function (req) { return setter(req, operation.getContext()); })
                  .then(operation.setContext)
                  .then(function () {
                  handle = forward(operation).subscribe({
                      next: observer.next.bind(observer),
                      error: observer.error.bind(observer),
                      complete: observer.complete.bind(observer),
                  });
              })
                  .catch(observer.error.bind(observer));
              return function () {
                  if (handle)
                      handle.unsubscribe();
              };
          });
      });
  }

  exports.setContext = setContext;

  Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=bundle.umd.js.map
