"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _util = _interopRequireDefault(require("util.promisify"));

var _child_process = _interopRequireDefault(require("child_process"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const exec = (0, _util.default)(_child_process.default.exec);
/**
 * Returns a git diff given a path to the repo, a commit,
 * an optional second commit, and an optional file.
 *
 * Returns the diff as a string.
 */

const gitDiff = (pathToRepo, commit1, commit2 = '', file = '') => exec(`git diff ${commit1} ${commit2} -- ${file}`, {
  cwd: pathToRepo,
  encoding: 'utf8',
  maxBuffer: 1024 * 1000
}).then(output => output.stdout);

var _default = gitDiff;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9naXRfZGlmZi5qcyJdLCJuYW1lcyI6WyJleGVjIiwiY2hpbGRQcm9jZXNzIiwiZ2l0RGlmZiIsInBhdGhUb1JlcG8iLCJjb21taXQxIiwiY29tbWl0MiIsImZpbGUiLCJjd2QiLCJlbmNvZGluZyIsIm1heEJ1ZmZlciIsInRoZW4iLCJvdXRwdXQiLCJzdGRvdXQiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFDQTs7OztBQUVBLE1BQU1BLElBQUksR0FBRyxtQkFBVUMsdUJBQWFELElBQXZCLENBQWI7QUFFQTs7Ozs7OztBQU1BLE1BQU1FLE9BQU8sR0FBRyxDQUFDQyxVQUFELEVBQWFDLE9BQWIsRUFBc0JDLE9BQU8sR0FBRyxFQUFoQyxFQUFvQ0MsSUFBSSxHQUFHLEVBQTNDLEtBQ2ROLElBQUksQ0FBRSxZQUFXSSxPQUFRLElBQUdDLE9BQVEsT0FBTUMsSUFBSyxFQUEzQyxFQUE4QztBQUNoREMsRUFBQUEsR0FBRyxFQUFFSixVQUQyQztBQUVoREssRUFBQUEsUUFBUSxFQUFFLE1BRnNDO0FBR2hEQyxFQUFBQSxTQUFTLEVBQUUsT0FBTztBQUg4QixDQUE5QyxDQUFKLENBSUdDLElBSkgsQ0FJUUMsTUFBTSxJQUFJQSxNQUFNLENBQUNDLE1BSnpCLENBREY7O2VBT2VWLE8iLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgcHJvbWlzaWZ5IGZyb20gJ3V0aWwucHJvbWlzaWZ5JztcbmltcG9ydCBjaGlsZFByb2Nlc3MgZnJvbSAnY2hpbGRfcHJvY2Vzcyc7XG5cbmNvbnN0IGV4ZWMgPSBwcm9taXNpZnkoY2hpbGRQcm9jZXNzLmV4ZWMpO1xuXG4vKipcbiAqIFJldHVybnMgYSBnaXQgZGlmZiBnaXZlbiBhIHBhdGggdG8gdGhlIHJlcG8sIGEgY29tbWl0LFxuICogYW4gb3B0aW9uYWwgc2Vjb25kIGNvbW1pdCwgYW5kIGFuIG9wdGlvbmFsIGZpbGUuXG4gKlxuICogUmV0dXJucyB0aGUgZGlmZiBhcyBhIHN0cmluZy5cbiAqL1xuY29uc3QgZ2l0RGlmZiA9IChwYXRoVG9SZXBvLCBjb21taXQxLCBjb21taXQyID0gJycsIGZpbGUgPSAnJykgPT5cbiAgZXhlYyhgZ2l0IGRpZmYgJHtjb21taXQxfSAke2NvbW1pdDJ9IC0tICR7ZmlsZX1gLCB7XG4gICAgY3dkOiBwYXRoVG9SZXBvLFxuICAgIGVuY29kaW5nOiAndXRmOCcsXG4gICAgbWF4QnVmZmVyOiAxMDI0ICogMTAwMFxuICB9KS50aGVuKG91dHB1dCA9PiBvdXRwdXQuc3Rkb3V0KTtcblxuZXhwb3J0IGRlZmF1bHQgZ2l0RGlmZjtcbiJdfQ==