"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _util = _interopRequireDefault(require("util.promisify"));

var _child_process = _interopRequireDefault(require("child_process"));

var _util2 = require("./util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const exec = (0, _util.default)(_child_process.default.exec);
/**
 * Pulls a repo given its path.
 *
 * Returns void. Throws error on failure.
 */

const gitPull = async pathToRepo => {
  const resolvedPath = (0, _util2.resolveHome)(pathToRepo);

  try {
    (0, _util2.validatePath)(resolvedPath);
  } catch (e) {
    return Promise.reject(e);
  }

  return exec(`git pull`, {
    cwd: resolvedPath
  });
};

var _default = gitPull;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9naXRfcHVsbC5qcyJdLCJuYW1lcyI6WyJleGVjIiwiY2hpbGRQcm9jZXNzIiwiZ2l0UHVsbCIsInBhdGhUb1JlcG8iLCJyZXNvbHZlZFBhdGgiLCJlIiwiUHJvbWlzZSIsInJlamVjdCIsImN3ZCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOztBQUNBOztBQUNBOzs7O0FBRUEsTUFBTUEsSUFBSSxHQUFHLG1CQUFVQyx1QkFBYUQsSUFBdkIsQ0FBYjtBQUVBOzs7Ozs7QUFLQSxNQUFNRSxPQUFPLEdBQUcsTUFBTUMsVUFBTixJQUFvQjtBQUNsQyxRQUFNQyxZQUFZLEdBQUcsd0JBQVlELFVBQVosQ0FBckI7O0FBRUEsTUFBSTtBQUNGLDZCQUFhQyxZQUFiO0FBQ0QsR0FGRCxDQUVFLE9BQU9DLENBQVAsRUFBVTtBQUNWLFdBQU9DLE9BQU8sQ0FBQ0MsTUFBUixDQUFlRixDQUFmLENBQVA7QUFDRDs7QUFFRCxTQUFPTCxJQUFJLENBQUUsVUFBRixFQUFhO0FBQUNRLElBQUFBLEdBQUcsRUFBRUo7QUFBTixHQUFiLENBQVg7QUFDRCxDQVZEOztlQVllRixPIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHByb21pc2lmeSBmcm9tICd1dGlsLnByb21pc2lmeSc7XG5pbXBvcnQgY2hpbGRQcm9jZXNzIGZyb20gJ2NoaWxkX3Byb2Nlc3MnO1xuaW1wb3J0IHt2YWxpZGF0ZVBhdGgsIHJlc29sdmVIb21lfSBmcm9tICcuL3V0aWwnO1xuXG5jb25zdCBleGVjID0gcHJvbWlzaWZ5KGNoaWxkUHJvY2Vzcy5leGVjKTtcblxuLyoqXG4gKiBQdWxscyBhIHJlcG8gZ2l2ZW4gaXRzIHBhdGguXG4gKlxuICogUmV0dXJucyB2b2lkLiBUaHJvd3MgZXJyb3Igb24gZmFpbHVyZS5cbiAqL1xuY29uc3QgZ2l0UHVsbCA9IGFzeW5jIHBhdGhUb1JlcG8gPT4ge1xuICBjb25zdCByZXNvbHZlZFBhdGggPSByZXNvbHZlSG9tZShwYXRoVG9SZXBvKTtcblxuICB0cnkge1xuICAgIHZhbGlkYXRlUGF0aChyZXNvbHZlZFBhdGgpO1xuICB9IGNhdGNoIChlKSB7XG4gICAgcmV0dXJuIFByb21pc2UucmVqZWN0KGUpO1xuICB9XG5cbiAgcmV0dXJuIGV4ZWMoYGdpdCBwdWxsYCwge2N3ZDogcmVzb2x2ZWRQYXRofSk7XG59O1xuXG5leHBvcnQgZGVmYXVsdCBnaXRQdWxsO1xuIl19