"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _git_log_format_markers = require("./constants/git_log_format_markers");

const parseCommit = commit => {
  const hash = commit[0];
  const authorName = commit[1];
  const authorEmail = commit[2];
  const date = commit[3];
  const messageIndex = commit.findIndex(line => line.match(_git_log_format_markers.gitLogMessageMarker));
  const fileIndex = commit.findIndex(line => line.match(_git_log_format_markers.gitLogFileMarker));
  const message = commit.slice(messageIndex + 1, fileIndex).join('\n');
  const files = commit.slice(fileIndex + 1);
  const addPattern = /^A\s([^\s]+)/;
  const deletePattern = /^D\s([^\s]+)/;
  const modifyPattern = /^M\s([^\s]+)/;
  const renamePattern = /^R[0-9]+\s(.+)\s(.+)/;

  const filterFileChanges = pattern => {
    return files.reduce((accumulator, file) => {
      const match = file.match(pattern);

      if (match) {
        accumulator.push({
          path: match[1]
        });
      }

      return accumulator;
    }, []);
  };

  const filesRenamed = files.reduce((accumulator, file) => {
    const match = file.match(renamePattern);

    if (match) {
      accumulator.push({
        oldPath: match[1],
        newPath: match[2]
      });
    }

    return accumulator;
  }, []);
  const parsedCommit = {
    hash,
    authorName,
    authorEmail,
    date,
    message,
    filesAdded: filterFileChanges(addPattern),
    filesDeleted: filterFileChanges(deletePattern),
    filesModified: filterFileChanges(modifyPattern),
    filesRenamed
  };
  return parsedCommit;
};

var _default = parseCommit;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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