<html xmlns="http://www.w3.org/1999/xhtml" style="overflow-y: hidden;">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon"/>
  <title>Site under Updating</title>
<style>

/*=== Font Styles === */

@font-face {
    font-family: 'PTSansRegular';
    src: url('images/updating/fonts/pt-sans/PTS55F-webfont.eot');
    src: url('images/updating/fonts/pt-sans/PTS55F-webfont.eot?#iefix') format('embedded-opentype'), url('images/updating/fonts/pt-sans/PTS55F-webfont.woff') format('woff'), url('images/updating/fonts/pt-sans/PTS55F-webfont.ttf') format('truetype'), url('images/updating/fonts/pt-sans/PTS55F-webfont.svg#PTSansRegular') format('svg');
    font-weight: normal;
    font-style: normal;
}


/* === General Styles === */

html,
span,
head,
h1,
h2,
h3,
h4,
h5,
h6,
p,
blockquote,
a,
font,
img,
small,
strong,
ol,
ul,
li {
    margin: 0;
    padding: 0;
    border: 0;
    outline: 0;
    font-size: 100%;
    background: transparent;
}

ol,
ul {    list-style: none }

blockquote,
q {    quotes: none }

body {
    font-family: PTSansRegular;
    margin: 0;
    padding: 0;
    border: 0;
    outline: 0;
    font-size: 100%;
    line-height: 1;
}

body {    background: #ffffff none repeat scroll 0 0 }

.container {
    width: 802px;
    margin: 0 auto;
}

#main {
    margin: 0 auto;
    padding: 0;
    background: #ECECEC;
    height: 430px;
}


/* === Header Styles === */

#header {
    margin: auto;
    margin-top: 20px;
    margin-bottom: 10px;
    height: 50px;
}

#logo {
    float: left;
    padding-left: 0px;
}

#contactDetails {
    padding-top: 13px;
    font: bold 15px moserrat !important;
    color: #656464;
    text-align: right;

    float: right;
}

#contactDetails a {
    font: bold 15px moserrat !important;
    color: #656464;
    text-decoration: none;

    letter-spacing: 0.5px;
}


/* === Content Styles === */

#content {
	  padding: 10px 44px;
    background-position: right top;
    background-repeat: no-repeat;
	}

#content a {color: #ffffff; text-decoration: none;}
#content a:hover {color: #9CC9EC; text-decoration: underline;}

.backgroundOfText{
    background: url(images/updating/page_background.jpg) no-repeat center center;
    text-align: center;
    color: #E5E5E5;
    height: 345px;
}

.text1{
    padding-top: 70px;
    font: 40px moserrat;
    color: #FFFFFF;
}

.text2{
    padding-top: 30px;
    font: 30px moserrat;
    color: #FFFFFF;
}

.urls{
    padding-top: 20px;
    text-align: center;
    color: #368AC9;
}

.urls a{
    font: bold 15px chivo;
    color: #368AC9;
    text-decoration: none;
}
.copyright{
    margin-top: 6px;
    font: bold 13px chivo;
    color: #656464;
}
.copyright a{
    color: #656464;
    text-decoration: none;
}

a.prev {
    float: left;
    margin-top: 50px;
    margin-left: 50px;
}

a.next {
    float: right;
    margin-top: 50px;
    margin-right: 50px;
}

</style>
</head>
<body>
<div class="container">
    <div id="header">
        <div id="logo">
            <a href="http://www.processmaker.com" target="_blank"><img src="images/processmaker.logo.jpg" alt="logo"/></a>
        </div>

        <div id="contactDetails">
            <p><a href="mailto:info@processmaker.com">info@processmaker.com</a></p>
            <p>phone: (617) 340-3377</p>
        </div>

        <div style="clear:both"></div>
    </div>

    <div id="main">
        <div class="backgroundOfText">
            <div class="text1">
                This application is being updated <br />
                and it will be back shortly.
            </div>
            <div class="text2">Thank you for your patience</div>
        </div>

        <div class="urls">
            <div>
                <a href="http://www.processmaker.com/privacy-statement">Privacy Statement</a> -
                <a href="http://www.processmaker.com/security-statement">Security Statement</a> -
                <a href="http://www.processmaker.com/terms-of-service">Terms of Service</a> -
                <a href="http://www.processmaker.com/commercial-license">Commercial License</a> -
                <a href="http://www.processmaker.com/contact-us">Contact Us</a> -
                <a href="http://feeds.feedburner.com/processmaker">RSS</a>
            </div>

            <div class="copyright">
                Copyright 2000 - <?php echo date('Y'); ?> ProcessMaker Inc. &nbsp;&nbsp;<a href="http://www.processmaker.com">www.processmaker.com</a>
            </div>
        </div>
    </div>
</div><!--end class container-->

</body>
</html>