<?php

class {className}Plugin extends PMPlugin
{
  {dashboardAttribute}
  
  public function {className}Plugin($sNamespace, $sFilename = null)
  {
    $res = parent::PMPlugin($sNamespace, $sFilename);
    $this->sFriendlyName = "{className} Plugin";
    $this->sDescription  = "Autogenerated plugin for class {className}";
    $this->sPluginFolder = "{className}";
    $this->sSetupPage    = "setup";
    $this->iVersion      = 1;
    //$this->iPMVersion    = 2425;
    $this->aWorkspaces   = null;
    //$this->aWorkspaces = array("os");
    
    {dashboardAttributeValue}
    
    return $res;
  }

  public function setup()
  {
    <!-- START BLOCK : changeLogo -->
    $this->setCompanyLogo("/plugin/{className}/{className}.png");
    <!-- END BLOCK : changeLogo -->
    <!-- START BLOCK : menu -->
    $this->registerMenu("processmaker", "menu{className}.php");
    <!-- END BLOCK : menu -->
    <!-- START BLOCK : menuCases -->
    $this->registerMenu("cases", "menuCases{className}.php");
    <!-- END BLOCK : menuCases -->
    <!-- START BLOCK : ontransit -->
    //$this->registerMenu("processmaker", "menu{className}OnTransit.php");
    <!-- END BLOCK : ontransit -->
    <!-- START BLOCK : externalStep -->
    $this->registerStep("{GUID}", "step{className}Application", "{className} external step");
    <!-- END BLOCK : externalStep -->
    <!-- START BLOCK : report -->
    $this->registerReport();
    <!-- END BLOCK : report -->
    <!-- START BLOCK : PmFunction -->
    $this->registerPmFunction();
    <!-- END BLOCK : PmFunction -->
    <!-- START BLOCK : redirectLogin -->
    $this->redirectLogin("PROCESSMAKER_{className}", "users/users_List");
    <!-- END BLOCK : redirectLogin -->
    
    {dashboardSetup}
  }

  public function install()
  {
    <!-- START BLOCK : createPermission -->
    $RBAC = RBAC::getSingleton() ;
    $RBAC->initRBAC();
    $roleData = array();
    $roleData["ROL_UID"] = G::GenerateUniqueId();
    $roleData["ROL_PARENT"] = "";
    $roleData["ROL_SYSTEM"] = "00000000000000000000000000000002";
    $roleData["ROL_CODE"] = "PROCESSMAKER_{className}";
    $roleData["ROL_CREATE_DATE"] = date("Y-m-d H:i:s");
    $roleData["ROL_UPDATE_DATE"] = date("Y-m-d H:i:s");
    $roleData["ROL_STATUS"] = "1";
    $RBAC->createRole($roleData);
    $RBAC->createPermision("PM_{className}");
    <!-- END BLOCK : createPermission -->
  }
  
  public function enable()
  {
    {dashboardEnable}
  }

  public function disable()
  {
    {dashboardDisable}
  }
  
  <!-- START BLOCK : dashboard -->
  public function dashletInsert()
  {

    
    $connection = Propel::getConnection(DashletPeer::DATABASE_NAME);
    
    foreach ($this->dashletsUids as $dashletData) {
      $dashlet = new Dashlet();
      
      if (is_null($dashlet->load($dashletData["DAS_UID"]))) {
        $dashlet->fromArray($dashletData, BasePeer::TYPE_FIELDNAME);
        $connection->begin();
        $dashlet->save();
        $connection->commit();
      }
    }
  }
  
  public function dashletDelete()
  {

    
    foreach ($this->dashletsUids as $dashletData) {
      $criteria = new Criteria("workflow");
      $criteria->add(DashletPeer::DAS_UID, $dashletData["DAS_UID"]);
      DashletPeer::doDelete($criteria);
    }
  }
  <!-- END BLOCK : dashboard -->
}

$oPluginRegistry = PMPluginRegistry::getSingleton();
$oPluginRegistry->registerPlugin("{className}", __FILE__);
