"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.providesFieldsMissingExternal = void 0;
const graphql_1 = require("graphql");
const utils_1 = require("../../utils");
exports.providesFieldsMissingExternal = ({ schema, }) => {
    var _a;
    const errors = [];
    const types = schema.getTypeMap();
    for (const [typeName, namedType] of Object.entries(types)) {
        if (!graphql_1.isObjectType(namedType))
            continue;
        for (const [fieldName, field] of Object.entries(namedType.getFields())) {
            const fieldFederationMetadata = utils_1.getFederationMetadata(field);
            const serviceName = fieldFederationMetadata === null || fieldFederationMetadata === void 0 ? void 0 : fieldFederationMetadata.serviceName;
            if (!serviceName)
                continue;
            const fieldType = field.type;
            if (!graphql_1.isObjectType(fieldType))
                continue;
            const fieldTypeFederationMetadata = utils_1.getFederationMetadata(fieldType);
            const externalFieldsOnTypeForService = (_a = fieldTypeFederationMetadata === null || fieldTypeFederationMetadata === void 0 ? void 0 : fieldTypeFederationMetadata.externals) === null || _a === void 0 ? void 0 : _a[serviceName];
            if (fieldFederationMetadata === null || fieldFederationMetadata === void 0 ? void 0 : fieldFederationMetadata.provides) {
                const selections = fieldFederationMetadata.provides;
                for (const selection of selections) {
                    const foundMatchingExternal = externalFieldsOnTypeForService
                        ? externalFieldsOnTypeForService.some(ext => ext.field.name.value === selection.name.value)
                        : undefined;
                    if (!foundMatchingExternal) {
                        errors.push(utils_1.errorWithCode('PROVIDES_FIELDS_MISSING_EXTERNAL', utils_1.logServiceAndType(serviceName, typeName, fieldName) +
                            `provides the field \`${selection.name.value}\` and requires ${fieldType}.${selection.name.value} to be marked as @external.`));
                    }
                }
            }
        }
    }
    return errors;
};
//# sourceMappingURL=providesFieldsMissingExternal.js.map